import { NextResponse } from 'next/server';
import { createClient } from '@/lib/supabase/server';

interface RouteParams {
  params: {
    categoryId: string;
  };
}

export async function GET(request: Request, { params }: RouteParams) {
  try {
    const { categoryId } = params;

    if (!categoryId) {
      return NextResponse.json(
        { error: 'Category ID is required' },
        { status: 400 }
      );
    }

    const supabase = await createClient();
    const { data, error } = await supabase
      .from('ai_tools')
      .select('*')
      .eq('category_id', categoryId)
      .eq('is_approved', true)
      .order('created_at', { ascending: false });

    if (error) {
      console.error('Error fetching tools by category:', error);
      return NextResponse.json({ error: error.message }, { status: 500 });
    }

    return NextResponse.json(data || []);
  } catch (error: any) {
    console.error('Failed to fetch tools by category:', error);
    return NextResponse.json(
      { error: error.message || 'Failed to fetch tools by category' },
      { status: 500 }
    );
  }
} 